package parser.visitor;

import parser.*;
/**
 * Map the given ACheckTagsAlgo across all the tokens in a chain (list) of SequenceTokens.
 * The algo is executed on the FIRST token of each SequenceSymbol and the 
 * result of all the executions is AND'ed together as the final result.
 * That is, the final result is true, only if all the elements individually 
 * calculate to true.
 */
public class ProcessListAlgo extends ACheckTagsAlgo<IGramTypeVisitor<Boolean, Object>> {
  public static final ProcessListAlgo Singleton = new ProcessListAlgo();
  private ProcessListAlgo() {}
  
  public Boolean mtCase(MTSymbol host, IGramTypeVisitor<Boolean, Object>... inps) {
    return true;   // Empty token at end of chain (list) defaults to true.
  }
  
  public Boolean seqCase(SequenceSymbol host, IGramTypeVisitor<Boolean, Object>... inps) { 
    boolean result = host.getSymbol1().execute(inps[0]);
    return result && host.getSymbol2().execute(this, inps);
  }   
}

